
import cadquery as cq

# Define the dimensions of the rectangle and the hole
length = 10.0  # Length of the rectangle
width = 5.0  # Width of the rectangle
thickness = 1.0  # Thickness of the rectangle
hole_diameter = 2.0  # Diameter of the hole

# Create the rectangle with the hole
result = (
    cq.Workplane("XY")
    .box(length, width, thickness)
    .faces(">Z")
    .workplane()
    .hole(hole_diameter)
)

# Export the result to an STL file with the specified new name
result.val().exportStl("Refine_2.stl")
