
import cadquery as cq

# Create the first rectangle
first_rectangle = cq.Workplane("front").rect(10, 20).extrude(1)

# Adjusting the position of the second rectangle to start halfway up the first and connect to the right edge
# First rectangle is 10 units wide, so we offset by half of that (5) and another half of the second rectangle's width.
# The y offset should be 20 / 2 = 10 (halfway up the first rectangle)
second_rectangle = cq.Workplane("front").transformed(offset=(7.5, 10, 0)).rect(5, 10).extrude(1)

# Combine the two rectangles
result = first_rectangle.union(second_rectangle)

# Save the output with the specified labels
result.val().exportStl("Refine_2.stl")
