
import cadquery as cq

# Parameters for the cylinder
diameter = 5.0  # Diameter of the cylinder
length = 100.0  # Length of the cylinder

# Create the cylinder
result = cq.Workplane("XY").circle(diameter / 2.0).extrude(length)

# Export the result to STL with the updated filename
result.val().exportStl("Refine_1.stl")
