
import cadquery as cq

# Create a cylinder
cylinder = cq.Workplane("XY").circle(10).extrude(20)

# Create a cutting tool
cutting_tool = cq.Workplane("XY").workplane(offset=15).rect(5, 5).extrude(10)

# Cut the cylinder with the cutting tool
result = cylinder.cut(cutting_tool)

# Export the result
result.val().exportStl("Generated.stl")
