
import cadquery as cq

# Define the dimensions of the main rectangle and the cut-out
main_length = 10.0
main_width = 5.0
main_height = 0.5
cutout_length = 4.0
cutout_width = 2.0
cutout_height = 0.5

# Create the main rectangle
result = cq.Workplane("XY").box(main_length, main_width, main_height)

# Centering the cut-out at the midpoint of main rectangle's length and slightly above the midpoint of its height
# Midpoint of main_length is main_length / 2, adjusted from one of its edges, should be zero offset
# For width, above the midpoint: main_width / 2 is the midpoint, moving slightly upwards (e.g., +0.1)
result = result.faces(">Z").workplane().center(0, main_width/2 + 0.1).rect(cutout_length, cutout_width).cutThruAll()

# Export the result
result.val().exportStl("Refine_1.stl")
