
import cadquery as cq

# Adjusted parameters for the cylinder
outer_radius = 10.0  # Outer radius of the cylinder remains unchanged
inner_radius = 1.0  # Reduced inner radius from 2.0 to 1.0
height = 50.0  # Height of the cylinder remains unchanged

# Create the outer cylinder
outer_cylinder = cq.Workplane("XY").circle(outer_radius).extrude(height)

# Create the inner cylinder
inner_cylinder = cq.Workplane("XY").circle(inner_radius).extrude(height)

# Subtract the inner cylinder from the outer cylinder to create the hollow part
result = outer_cylinder.cut(inner_cylinder)

# Export the result with the specified file name
result.val().exportStl("Refine_1.stl")
