
import cadquery as cq

# Parameters for the cylinder
outer_radius = 10.0  # Outer radius of the cylinder
inner_radius = 1.0  # Reduced inner radius for a smaller hollow center
height = 50.0  # Height of the cylinder

# Create a hollow cylinder with open ends
result = (
    cq.Workplane("XY")
    .cylinder(height, outer_radius, centered=True)
    .faces('<Z').shell(-inner_radius)  # Subtract the inner cylinder to create a hollow space with open ends
)

# Export the result with the correct file name as specified
result.val().exportStl("Refine_2.stl")
