
import cadquery as cq

# Create the first cylinder
cylinder1 = cq.Workplane("XY").circle(10).extrude(20)

# Create the second cylinder. It should start from the bottom center of the first cylinder
cylinder2 = cylinder1.faces("<Z").workplane().circle(8).extrude(30)

# Combine the two cylinders
result = cylinder1.union(cylinder2)

# Export the result
result.val().exportStl("Refine_1.stl")
