
import cadquery as cq

# Define the square's side length and the extrusion height
side_length = 10.0
# Increase the extrusion height for a more 'extensive' extrusion
extrusion_height = 40.0  # Adjusted to a more extensive height as an example

# Create a workplane, then a square, and then extrude it
result = (
    cq.Workplane("XY")
    .rect(side_length, side_length)
    .extrude(extrusion_height)
)

# Export the result to an STL file with a new file name to reflect the modification
result.val().exportStl("Refine_1.stl")
