
import cadquery as cq

# Define the dimensions of the table and legs
table_length = 90.0
table_width = 60.0
table_thickness = 2.0

leg_length = 30.0  # table_length / 3
leg_height = table_width  # Assuming leg height to be the same as the width of the table or custom
leg_thickness = 5.0

# Create the table surface
table = cq.Workplane("XY").box(table_length, table_width, table_thickness)

# Create the legs (updated to be below the table and at the sides)
leg1 = (
    cq.Workplane("front")
    .workplane(offset=-table_width / 2 + leg_thickness / 2)
    .moveTo(-table_length / 2 + leg_length / 2, 0)
    .box(leg_length, leg_height, leg_thickness)
)

leg2 = (
    cq.Workplane("front")
    .workplane(offset=-table_width / 2 + leg_thickness / 2)
    .moveTo(table_length / 2 - leg_length / 2, 0)
    .box(leg_length, leg_height, leg_thickness)
)

# Combine the table surface and the legs
result = table.union(leg1).union(leg2)

# Export the result as STL
result.val().exportStl("Refine_1.stl")
