
import cadquery as cq

# Create a short cylinder with a large diameter
cylinder = cq.Workplane("XY").circle(10.0).extrude(5.0)

# Create a short and narrow rectangular prism
rect_prism = cq.Workplane("XY").box(12.0, 2.0, 2.0)

# Translate the rectangular prism to sit on top of the cylinder
rect_prism = rect_prism.translate((0, 0, 7.0))

# Combine the two shapes
result = cylinder.union(rect_prism)

# Export the result
result.val().exportStl("Generated.stl")
