
import cadquery as cq

# Define the dimensions:
width = 10.0
height = 20.0
thickness = 2.0
semi_circle_radius = width / 2.0
hole_diameter = semi_circle_radius / 2.0

# Calculate the total height of the rectangle part:
rectangle_height = height - semi_circle_radius

# Create the U-shaped tag:
result = (
    cq.Workplane("front")
    .rect(width, rectangle_height)  # Draw the rectangle
    .moveTo(0, rectangle_height / 2)  # Move to bottom of the rectangle
    .threePointArc((semi_circle_radius, 0), (width, rectangle_height / 2))  # Draw the semi-circle
    .hLineTo(0)  # Closing the sketch to form a "U"
    .extrude(thickness)  # Extrude the sketch
    .faces("<Z")  # Select the bottom face
    .workplane(centerOption="CenterOfMass")  # Change workplane to the center of mass (inside the semi-circle)
    .hole(hole_diameter)  # Create the hole
)

# Export the result:
result.val().exportStl("Refine_1.stl")
