
import cadquery as cq

# Define the dimensions:
width = 10.0
height = 20.0
thickness = 2.0
semi_circle_radius = width / 2.0
hole_diameter = semi_circle_radius / 4.0  # 1/4th of the semi-circle diameter

# Calculate the total height of the rectangle part:
rectangle_height = height - semi_circle_radius

# Create the U-shaped tag:
result = (
    cq.Workplane("front")
    .rect(width, rectangle_height)  # Draw the rectangle
    .moveTo(0, -rectangle_height / 2)  # Move to bottom of the rectangle
    .threePointArc((semi_circle_radius, -semi_circle_radius), (width, -rectangle_height / 2))  # Draw the semi-circle
    .hLineTo(0)  # Closing the sketch to form a "U"
    .extrude(thickness)  # Extrude the sketch
)

# Locate the correct face and the correct center to place the hole:
result = result.faces(">Z").workplane(centerOption="CenterOfMass")

# Create the hole at the center of the semi-circle. This is assuming the rectangle part is at the top:
result = result.circle(hole_diameter / 2.0).cutThruAll()

# Export the result:
result.val().exportStl("Refine_2.stl")
