
import cadquery as cq

# Create a long rectangle and extrude it
result = cq.Workplane("front").rect(100, 10).extrude(10)

# Adjusting the positions of the holes to be closer to the ends of the rectangle
# Assuming the total length of the rectangle is 100, placing holes at 5 units from each end
result = result.faces(">Z").workplane().pushPoints([(-45, 0), (45, 0)]).hole(2)

# Save the output
result.val().exportStl("Refine_1.stl")
