
import cadquery as cq

# Parameters for the circle and holes
circle_dia = 10.0  # Diameter of the main circle
hole_dia = 1.0  # Diameter of the holes
hole_offset = 3.0  # Distance from the center of the circle to the center of the holes
extrude_depth = 1.0  # Extrude depth of the circle

# Create the main circle and extrude it
result = cq.Workplane("XY").circle(circle_dia / 2.0).extrude(extrude_depth)

# Adding holes with better placement control
result = result.faces(">Z").workplane().pushPoints([
    (-hole_offset, -hole_offset),
    (-hole_offset, hole_offset),
    (hole_offset, -hole_offset),
    (hole_offset, hole_offset)
]).hole(hole_dia)

# Export the result with the updated file name
result.val().exportStl("Refine_1.stl")
