
import cadquery as cq

# Create a cylinder with a height twice its diameter
diameter = 10
height = 20
cylinder = cq.Workplane("XY").circle(diameter/2).extrude(height)

# Rotate the cylinder around Y-axis before slicing
half_cylinder = cylinder.rotate((0, 0, 0), (0, 1, 0), 45)

# Create a cutting shape that intersects the cylinder at an angle (orthogonal to previous rotation)
cutting_shape = cq.Workplane("YZ").box(height, diameter*1.5, diameter, centered=(True, True, False)).translate((0, 0, diameter*0.75))

# Intersect the rotated cylinder with this angled box to slice it
sliced_cylinder = half_cylinder.intersect(cutting_shape)

# Remove 1/3rd of the material
# First, find a suitable cutting box for removing the material
cutting_width = diameter * 0.5 / 3
material_remove_box = cq.Workplane("XZ").box(cutting_width, diameter*1.5, height).translate((-cutting_width/2, 0, height/2))

# Cut the material from half-cylinder
sliced_cylinder = sliced_cylinder.cut(material_remove_box)

# Save the output
sliced_cylinder.val().exportStl("Refine_1.stl")
