
import cadquery as cq

# Create a square and extrude it to create a box
result = cq.Workplane("XY").rect(10, 10).extrude(10)

# Create a tiny rectangle in the center of the square and cut through
result = result.faces(">Z").workplane().rect(1, 1).cutThruAll()

# Save the output
result.val().exportStl("Generated.stl")
