
import cadquery as cq

# Create a flat square base
result = cq.Workplane("XY").rect(10, 10).extrude(0.1)  # Small extrusion to create a flat square

# Create a tiny rectangle in the center of the square and cut through
result = result.faces(">Z").workplane().rect(1, 1).cutThruAll()  # Cutting through the thin square

# Save the output with accurate naming as per the instructions
result.val().exportStl("Refine_2.stl")
