
import cadquery as cq

# Create a parallelogram by defining its points and closing the loop
parallelogram = cq.Workplane("XY").polyline([(0, 0), (4, 0), (5, 2), (1, 2)]).close()

# Extrude the parallelogram to create a 3D object
extruded = parallelogram.extrude(10)

# Draw a square on the top face of the extruded parallelogram
# Ensuring the square is properly located and sized to penetrate through the object
square = extruded.faces(">Z").workplane().rect(3, 3)

# Negatively extrude the square (cut through), making sure it goes through the entire shape
result = square.cutThruAll()

# Save the output
result.val().exportStl("Refine_2.stl")
