
import cadquery as cq

# Define the dimensions
square_size = 10.0
rectangle_width = square_size / 5
rectangle_length = square_size
extrusion_length = 5.0

# Create the main square and extrude it
result = cq.Workplane("XY").box(square_size, square_size, extrusion_length, centered=(True, True, False))

# Error in initial code: Need to place one rectangle on the left and one on the right
# Create the first rectangle on the left
result = result.faces(">X").workplane(centerOption="CenterOfBoundBox").move(-square_size/2 - rectangle_width/2, 0).rect(rectangle_width, rectangle_length).extrude(-extrusion_length)

# Create the second rectangle on the right
result = result.faces("<X").workplane(centerOption="CenterOfBoundBox").move(square_size/2 + rectangle_width/2, 0).rect(rectangle_width, rectangle_length).extrude(-extrusion_length)

# Export the result
result.val().exportStl("Refine_1.stl")
