
import cadquery as cq

# Create a workplane to draw the letter R
r_shape = cq.Workplane("front")

# Draw the outline of an 'R', starting with the straight part
r_shape = r_shape.moveTo(0, 0).lineTo(0, 2)  # Main straight line

# Draw the top arc for the 'R'
r_shape = r_shape.threePointArc((0.5, 2.5), (1, 2))

# Draw the downward line to start the leg
r_shape = r_shape.lineTo(1, 1)

# Draw arc to complete the leg
r_shape = r_shape.threePointArc((0.75, 0.75), (0.5, 1))

# Close the shape at the bottom
r_shape = r_shape.lineTo(0, 0).close()

# Extrude the sketch into a 3D solid
result = r_shape.extrude(0.5)

# Export the result to STL with the corrected filename
result.val().exportStl("Refine_2.stl")
