
import cadquery as cq

# Create the base of the thermometer
base = cq.Workplane("XY").circle(5).extrude(0.5)

# Create the stem of the thermometer
stem = cq.Workplane("XY").rect(1, 50).extrude(0.4)

# Combine the base and the stem
thermometer = base.union(stem)

# Export the result
thermometer.val().exportStl("Generated.stl")
