
import cadquery as cq

# Create the base of the thermometer
base = cq.Workplane("XY").circle(5).extrude(0.5)

# Adjust the stem of the thermometer to be directly attached at the top edge of the base
stem = (
    cq.Workplane("XY")
    .moveTo(0, 5)
    .rect(1, 50)
    .extrude(0.4)
    .translate((0, 25, 0))  # Align stem directly with the top edge of the base 
)

# Combine the base and the stem
thermometer = base.union(stem)

# Export the new version of the result
thermometer.val().exportStl("Refine_2.stl")
