
import cadquery as cq

# Define the dimensions
outer_radius = 10.0  # Outer radius of the cylinder
inner_radius = 0.1   # Radius of the small hole
height = 20.0        # Height of the cylinder

# Create the outer cylinder
result = cq.Workplane("XY").circle(outer_radius).extrude(height)

# Create the small hole
result = result.faces(">Z").workplane().center(0, 0).circle(inner_radius).cutThruAll()

# Export the result with the specified file name
result.val().exportStl("Refine_1.stl")
