
import cadquery as cq

# Parameters for the cylinder and holes
cylinder_height = 100.0
cylinder_diameter = 10.0
hole_diameter = 8.0

# Create the cylinder
result = cq.Workplane("XY").circle(cylinder_diameter / 2).extrude(cylinder_height)

# Create the top hole, positioned slightly below the top face for visibility
result = result.faces(">Z").workplane(offset=-5).hole(hole_diameter)

# Create two bottom holes: one closer to the center and the other further from the center
# Adjusting positions to ensure both holes are visible and distinct in placement
result = result.faces("<Z").workplane(offset=5).center(-cylinder_diameter / 4, 0).hole(hole_diameter)
result = result.faces("<Z").workplane(offset=5).center(cylinder_diameter / 4, 0).hole(hole_diameter)

# Export the updated result with correct file naming as per the requirement
result.val().exportStl("Refine_2.stl")
