
import cadquery as cq

# Define the dimensions
square_length = 10.0
square_width = 10.0
small_extrude_amount = 1.0
rectangle_length = square_length
rectangle_width = square_width / 2.0
large_extrude_amount = 100.0

# Create the base square and extrude it
result = (
    cq.Workplane("XZ")
    .rect(square_length, square_width)
    .extrude(small_extrude_amount)
)

# Create the rectangle and extrude it to form the pillar
result = (
    result.faces(">Y")
    .workplane(centerOption="CenterOfMass")
    .rect(rectangle_length, rectangle_width)
    .extrude(large_extrude_amount)
)

# Export the result
result.val().exportStl("Generated.stl")
