
import cadquery as cq

# Define the dimensions of the trapezoids
base1 = 10.0
base2 = 5.0
height = 20.0
extrude_dist1 = 10.0
extrude_dist2 = 2.0

# Create the first trapezoid
result = (
    cq.Workplane("front")
    .lineTo(base1 / 2, 0)
    .lineTo(base2 / 2, height)
    .lineTo(-base2 / 2, height)
    .lineTo(-base1 / 2, 0)
    .close()
    .extrude(extrude_dist1)
)

# Create the second trapezoid
result2 = (
    cq.Workplane("front")
    .workplane(offset=extrude_dist1)
    .lineTo((base1 + 2) / 2, 0)
    .lineTo((base2 + 2) / 2, height + 2)
    .lineTo(-(base2 + 2) / 2, height + 2)
    .lineTo(-(base1 + 2) / 2, 0)
    .close()
    .extrude(extrude_dist2)
)

# Combine the two trapezoids
result = result.union(result2)

# Export the result
result.val().exportStl("Generated.stl")
