
import cadquery as cq

# Define the dimensions of the rectangle and the hole
length = 10.0
width = 5.0
thickness = 2.0
hole_diameter = 1.0

# Create the rectangle and extrude it
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Add the hole, slightly closer to the left side
result = (
    result.faces(">Z")
    .workplane()
    .center(-length / 4, 0)  # Adjusting to ensure it's more visually distinct
    .hole(hole_diameter)
)

# Export the result
result.val().exportStl("Refine_1.stl")
