
import cadquery as cq

# Define the dimensions of the tag
length = 70.0  # Increased length to better fit the visual target
width = 40.0  # Increased width for the same reason
thickness = 5.0  # Increased the thickness for durability
radius = 10.0  # Increased radius for softer rounding at the top corners
hole_diameter = 10.0  # Adjusted the size of the hole to make it proportionate 

# Create the tag with adjusted parameters
result = (
    cq.Workplane("front")
    .rect(length, width)
    .edges(">Z and |Z").fillet(radius)  # Applying fillet to only top horizontal edges
    .extrude(thickness)
    .faces(">Z")
    .workplane(centerOption="CenterOfBoundBox")  # Center the workplane on the entire bounding box on Z
    .transformed(offset=(0, 0, -5))  # Move the workplane down by 5 units to place the hole below the top face center
    .hole(hole_diameter)
)

# Export the result with the revised filename
result.val().exportStl("Refine_2.stl")
