
import cadquery as cq

# Define the parameters of the ring
outer_radius = 10.0
inner_radius = 5.0
thickness = 2.0

# Create the ring and extrude along the y-axis
result = (
    cq.Workplane("XY")
    .circle(outer_radius)
    .circle(inner_radius)
    .workplane(offset=thickness, invert=True)  # Rotate workplane to align extrusion along y-axis
    .extrude(thickness, both=True)  # Extrude symmetrically along the y-axis
)

# Export the result
result.val().exportStl("Refine_1.stl")
