
import cadquery as cq

# Create a sketch of a rectangle with specified dimensions
rectangle = cq.Workplane("XY").rect(10, 20) # Width 10, Height 20

# Extrude the rectangle with a specified depth
extruded_rectangle = rectangle.extrude(5)  # Depth 5

# Add a circular hole at the center of the rectangle with a specified diameter
result = extruded_rectangle.faces(">Z").workplane().hole(2)  # Diameter 2

# Save the output with a modified file name according to request
result.val().exportStl("Refine_2.stl")
