
import cadquery as cq

# Define the dimensions of the rectangle and trapezium
rect_length = 100.0
rect_width = 20.0
trap_height = 30.0
trap_top_length = 10.0

# Create a combined sketch of a rectangle and a trapezium
result = cq.Workplane("front")

# Create the rectangle
result = result.rect(rect_length, rect_width)

# Move to the top center of the rectangle to attach the trapezium at the correct position
result = result.transformed(offset=cq.Vector(rect_length / 2, rect_width / 2, 0))

# Draw the trapezium with correct attachment
# Note: Negative in first lineTo to extend opposite of the rectangle centre
result = result.lineTo(-(rect_width - trap_top_length) / 2, trap_height) \
              .lineTo((rect_width + trap_top_length) / 2, trap_height)  \
              .lineTo((rect_width + trap_top_length) / 2, 0)            \
              .lineTo(-(rect_width - trap_top_length) / 2, 0)

# Close the sketch and extrude
result = result.close().extrude(rect_width)  # Extruding based on the length of the shorter edge of the rectangle

# Export the result
result.val().exportStl("Refine_1.stl")
