
import cadquery as cq

# Define the points for the triangles
# Adjusting the height and base points to create an exact equilateral for the center triangle
# The side triangles are adjusted for scalene properties and acute angles
points = [
    (0, 0),        # Start point
    (1, 1.75),     # Left mountain peak (adjusted)
    (2, 0),        # Base between first and second peak
    (3, 2.5),      # Second peak (equilateral triangle peak)
    (4, 0),        # Base between second and third peak
    (5, 1.75),     # Right mountain peak (adjusted)
    (6, 0)         # End point
]

# Create the profile and adjust extrusion depth to 10 for a better 3D look
result = cq.Workplane("front").polyline(points).close().extrude(10)

# Export the result
result.val().exportStl("Refine_1.stl")
