
import cadquery as cq

# Define the points for the triangles
# Adjusting the height and base points to create an exact equilateral for the center triangle
# The side triangles are adjusted for scalene properties and acute angles
points = [
    (0, 0),        # Start point
    (1, 2),        # Left mountain peak (adjusted for acute scalene)
    (2, 0),        # Base between first and second peak
    (3, 3),        # Second peak (equilateral triangle peak, adjusted for height)
    (4, 0),        # Base between second and third peak
    (5, 2),        # Right mountain peak (adjusted for acute scalene)
    (6, 0)         # End point
]

# Create the profile and adjust extrusion depth to 10 for a better 3D look
result = cq.Workplane("front").polyline(points).close().extrude(10)

# Export the result
result.val().exportStl("Refine_2.stl")
