
import cadquery as cq

# Base cylinder with defined height and radius.
cylinder = cq.Workplane("XY").circle(10).extrude(20)

# A hole in the middle using cut operation with half the radius.
cylinder_with_hole = cylinder.faces(">Z").workplane().circle(5).cutThruAll()

# Define a small square and position it correctly on the outer edge of the cylinder.
# Then negatively extrude it by the same height as the cylinder to create a channel.
square_channel = cylinder.faces(">Z").workplane().center(10, 0).rect(2, 2).cutBlind(-20)

# Combine the operations to get the final form.
final_result = cylinder_with_hole.union(square_channel)

# Export the result in STL format.
final_result.val().exportStl("Refine_1.stl")
