
import cadquery as cq

# Create a rectangular object
result = cq.Workplane("front").rect(10, 20).extrude(5)

# Create a small circular hole in the top right corner
result = result.faces(">Z").workplane().center(5, 10).hole(1)

# Save the output
result.val().exportStl("Generated.stl")
