
import cadquery as cq

# Create a rectangular object
result = cq.Workplane("front").rect(10, 20).extrude(5)

# Improved placement for the hole: Move slightly away from the very corner to ensure it's visible
# Estimated correct coordinates adjustment might be needed after the placement visual confirmation
result = result.faces(">Z").workplane().center(-3, -8).hole(1)

# Save the output
result.val().exportStl("Refine_1.stl")
