
import cadquery as cq

# Create a rectangular object
result = cq.Workplane("front").rect(10, 20).extrude(5)

# Adjust the position of the hole to be more marginally placed in the top right corner,
# assuming the hole size of 1 is satisfactory
result = result.faces(">Z").workplane().center(-1, -1).hole(1)

# Save the output
result.val().exportStl("Refine_2.stl")
