
import cadquery as cq

# Parameters for the model
diameter = 10.0  # Diameter of the cylinder
height = 20.0  # Height of the cylinder
rectangle_width = 0.8 * diameter  # Width of the rectangle
rectangle_height = 0.1 * rectangle_width  # Height of the rectangle
rectangle_extrude_height = 0.5 * height  # Extrusion height of the rectangle

# Create the base cylinder
result = cq.Workplane("XY").circle(diameter / 2.0).extrude(height)

# Create the rectangle on top of the cylinder
result = (
    result.faces(">Z")
    .workplane(centerOption="CenterOfMass")
    .rect(rectangle_width, rectangle_height)
    .extrude(rectangle_extrude_height)
)

# Export the result
result.val().exportStl("Refine_1.stl")
