
import cadquery as cq

# Create a square and extrude it
result = cq.Workplane("XY").box(10, 10, 1)

# Cut a right triangle out of the square from the bottom-right corner.
# Triangle vertices are at bottom-right corner (10,0), bottom-right upwards (10,10), bottom-right leftwards (0,0)
result = result.faces(">Z").workplane().moveTo(10, 0).polyline([(0, 0), (0, 10), (-10, 0)]).close().cutThruAll()

# Export the result
result.val().exportStl("Refine_1.stl")
