
import cadquery as cq

# Creating a square and extruding it to form a rectangular prism
# Define size for a square
square_size = 10
extrude_height = 1

result = cq.Workplane("XY").box(square_size, square_size, extrude_height)

# Cutting a large right triangle from the bottom-right corner
# Triangle vertices follow from the bottom-right corner (10,0) to (10,10) to (0,0)
result = result.faces(">Z").workplane().moveTo(square_size, 0).polyline([(0, 0), (0, square_size), (-square_size, 0)]).close().cutThruAll()

# Export the fixed STL file
result.val().exportStl("Refine_2.stl")
