
import cadquery as cq

# Define the points of the triangle
points = [(0, 0), (1, 0), (0, 1)]

# Create the workplane and draw the triangle
result = cq.Workplane("XY").polyline(points).close()

# Extrude the triangle to create a 3D object
result = result.extrude(0.1)

# Export the result
result.val().exportStl("Generated.stl")
