
import cadquery as cq

# Create the base square
base_square = cq.Workplane("XY").rect(10, 10).extrude(1)

# Create the smaller square on top of the base square
# Adjusted the height at which the second square starts its extrusion
smaller_square = cq.Workplane("XY").workplane(offset=1).rect(8, 8).extrude(1)

# Combine the two squares without any union function because we need them distinct
result = base_square.faces(">Z").workplane().rect(8, 8).extrude(1)

# Export the result with the corrected filename
result.val().exportStl("Refine_1.stl")
