
import cadquery as cq

# Define the parameters of the ring
outer_radius = 10.0  # Radius of the entire ring
inner_radius = 5.0   # Radius of the hollow part inside
extrude_length = 20.0  # Length to extrude the profile along the x-axis

# Create the ring by starting with an XZ plane (X-axis extrusion, Z-axis up)
ring = (
    cq.Workplane("XZ")
    .circle(outer_radius)  # Create the outer boundary of the ring
    .circle(inner_radius)  # Create the inner boundary (hollow part)
    .extrude(extrude_length, combine=True)  # Extrude the defined shape along the X-axis
)

# Export the resulting 3D model to an STL file
ring.val().exportStl("Refine_2.stl")
