
import cadquery as cq

# Define parameters for the book
book_thickness = 5.0
page_width = 100.0
page_height = 100.0
total_width = page_width * 2

# Start a new workplane to create the first page (left half of the open book)
left_page = cq.Workplane("XY").box(page_width, book_thickness, page_height).translate((-page_width/2, 0, page_height/2))

# Create the second page (right half of the open book), rotated at a larger angle around the Y axis
angle_degrees = 45  # increased angle for a more noticeably open book
right_page = cq.Workplane("XY")\
    .box(page_width, book_thickness, page_height)\
    .rotate((0, 0, 1), (0, 1, 0), angle_degrees)\
    .translate((page_width/2 * 0.95, 0, page_height/2))  # slight translation to better simulate an open book

# Combine the two parts to form the open book
book = left_page.union(right_page)

# Export the result to an STL file
book.val().exportStl("Refine_2.stl")
