
import cadquery as cq

# Create a cylinder
cylinder = cq.Workplane("XY").circle(10).extrude(20)

# Define the trapezium as a sector of the circle
trapezium = (
    cylinder.faces(">Z")  # select the top face of the cylinder
    .workplane()  # create a work plane on the top face
    .moveTo(0, 0)  # move to the center of the circle
    .polyline([(8, 0), (10, 3), (10, -3)])  # draw the trapezium as a sector
    .close()  # close the shape to form a solid
    .cutThruAll()  # cut the shape through the entire thickness
)

# Subtract the trapezium from the cylinder to create the desired cutout
result = cylinder.cut(trapezium)

# Export the STL file with the corrected name as requested
result.val().exportStl("Refine_2.stl")
