
import cadquery as cq

# Define the dimensions of the steps correctly
base_width = 60.0
base_height = 10.0
middle_width = 40.0
middle_height = 10.0
top_width = 20.0
top_height = 10.0
depth = 60.0  # Assuming depth corresponds to 'extrusion' depth in z-direction.

# Correct misspelled 'Workplane' and variable reference
workplane = cq.Workplane("front")

# Create the base of the pedestal
base = workplane.rect(base_width, depth).extrude(base_height)

# Create the middle step
# Positioned correctly above the base
middle = (workplane.workplane(offset=base_height)
                  .rect(middle_width, depth).extrude(middle_height))

# Create the top step
# Positioned correctly above the middle step
top = (workplane.workplane(offset=base_height + middle_height)
                .rect(top_width, depth).extrude(top_height))

# Combine all parts using correct method chaining
result = base.union(middle).union(top)

# Export the result to STL with revised filename
result.val().exportStl("Refine_2.stl")
