
import cadquery as cq

# Create the main body of the whistle
cylinder = cq.Workplane("XY").circle(10).extrude(5)

# Create the rectangular block
# Calculate the starting point at the top center edge of the cylinder
# Extend the rectangular block longer than the diameter of the cylinder (diameter = 20)
block = cq.Workplane("XY").transformed(offset=cq.Vector(0, 0, 5)).rect(22, 2).extrude(1)

# Combine the cylinder and the block with the block accurately positioned at the top center edge
whistle = cylinder.union(block)

# Export the result
whistle.val().exportStl("Refine_1.stl")
