
import cadquery as cq

# Dimensions for the workbench top and its features
length = 90.0
width = 30.0
thickness = width
inner_cut_depth = thickness - 5

# Dimensions for the legs
leg_length = 3 * width  # Leg length should be 3x its width
leg_width = width / 3

# Dimensions for the connecting rod
rod_diameter = leg_width - 4  # slightly less than the width of each leg
rod_length = length - 2 * leg_width  # Spanning only between the legs

# Create the hollow top of the workbench
top = (cq.Workplane("front")
       .box(length, width, thickness, centered=(True, True, False))
       .faces(">Z")
       .workplane()
       .rect(length - 5, width - 5)
       .cutBlind(-inner_cut_depth))

# Creating and positioning legs
leg = (cq.Workplane("front")
       .box(leg_width, leg_width, leg_length, centered=(True, True, False)))

# Distance from the center to place each leg
leg_offset = (length / 2) - (leg_width / 2)

# Adding legs to the workbench
workbench = top.union(leg.translate((-leg_offset, 0, -leg_length)))
workbench = workbench.union(leg.translate((leg_offset, 0, -leg_length)))

# Create and position the connecting rod
rod = (cq.Workplane("front")
      .cylinder(rod_length / 2, rod_diameter / 2)
      .rotate((0,0,1), (0,0,0), 90)  # Rotate to horizontal
      .translate((0, 0, -leg_length)))

# Combine the rod with the rest of the workbench
workbench = workbench.union(rod)

# Export the revised model
workbench.val().exportStl("Refine_2.stl")
