
import cadquery as cq

# Define the dimensions
hexagon_edge_length = 10.0
hexagon_height = 20.0
cylinder_diameter = hexagon_edge_length - 1.0  # Slightly smaller than the hexagon width
cylinder_height = hexagon_height / 2.0  # Half the height of the hexagon

# Create the hexagon and extrude it
hexagon = (
    cq.Workplane("XY")
    .polygon(6, hexagon_edge_length)
    .extrude(hexagon_height)
)

# Ensure the workplane for the cylinder is correctly centered on the hexagon
cylinder = (
    hexagon.faces(">Z")  # Select the top face of the hexagon
    .workplane(centerOption="CenterOfMass")  # Center the workplane based on the face's center of mass
    .circle(cylinder_diameter / 2.0)
    .extrude(cylinder_height)
)

# Export the result
cylinder.val().exportStl("Refine_1.stl")
